from typing import List

def mention(notes: List[float], coefs: List[float]) -> str:
  """ Indique la mention obtenue au baccalauréat selon les notes.
  @param notes les notes de la personne candidate
  @param coefs les coefficients des notes (notes[i] * coefs[i])
  @return la mention ("R", "P", "AB", "B", "TB" ou "F")

  Classes d'équivalences:
  >>> mention([8, 10, 9], [1, 2, 1])
  'R'
  >>> mention([8, 12, 9], [1, 2, 1])
  'P'
  >>> mention([12, 13], [1, 1])
  'AB'
  >>> mention([15], [1])
  'B'
  >>> mention([17], [1])
  'TB'
  >>> mention([19], [1])
  'F'

  Valeurs limites:
  >>> mention([10], [1])
  'P'
  >>> mention([12], [1])
  'AB'
  >>> mention([14], [1])
  'B'
  >>> mention([16], [1])
  'TB'
  >>> mention([18], [1])
  'F'
  """
  assert len(notes) == len(coefs), "il faut autant de coefficients que de notes"
  assert sum(coefs) != 0, "la somme des coefficients ne doit pas être nulle"

  total_points = 0
  total_coefs = 0

  for i in range(len(notes)):
    total_points += notes[i] * coefs[i]
    total_coefs += coefs[i]

  moyenne = total_points / total_coefs
  if moyenne < 10:
    resultat = "R"
  elif moyenne < 12:
    resultat = "P"
  elif moyenne < 14:
    resultat = "AB"
  elif moyenne < 16:
    resultat = "B"
  elif moyenne < 18:
    resultat = "TB"
  else:
    resultat = "F"
  return resultat

if __name__ == "__main__":
  import doctest; doctest.testmod()

